/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function.library;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionBase1;
import com.hp.hpl.jena.sparql.util.ALog;

public class date
extends FunctionBase1 {
    public NodeValue exec(NodeValue v) {
        if (!v.isString()) {
            ALog.warn(this, "date: argument not a string: " + v);
            throw new ExprEvalException("date: argument not a string: " + v);
        }
        String lexicalForm = v.getString();
        if (!lexicalForm.matches("\\d{4}-\\d{2}-\\d{2}")) {
            ALog.warn(this, "date: argument not in date format: " + v);
            throw new ExprEvalException("date: argument not in date format: " + v);
        }
        lexicalForm = lexicalForm + "T00:00:00Z";
        NodeValue nv = NodeValue.makeNode(lexicalForm, XSDDatatype.XSDdateTime);
        return nv;
    }
}

