/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemException;
import com.hp.hpl.jena.sparql.sse.ItemLocation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ItemList
extends ItemLocation {
    private List elements = new ArrayList();

    public ItemList(int line, int column) {
        super(line, column);
    }

    public ItemList() {
        super(-1, -1);
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public int hashCode() {
        return ((Object)this.elements).hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ItemList)) {
            return false;
        }
        return ((Object)this.elements).equals(((ItemList)other).elements);
    }

    public void addAll(ItemList itemList) {
        this.elements.addAll(itemList.elements);
    }

    public void add(Item item) {
        this.elements.add(item);
    }

    public void add(Node node) {
        this.elements.add(Item.createNode(node));
    }

    public void add(String symbol) {
        this.elements.add(Item.createSymbol(symbol));
    }

    public Item get(int idx) {
        return (Item)this.elements.get(idx);
    }

    public Item getFirst() {
        return this.get(0);
    }

    public Item getLast() {
        return this.get(this.size() - 1);
    }

    public Iterator iterator() {
        return this.elements.iterator();
    }

    public Item car() {
        if (this.elements.size() == 0) {
            throw new ItemException("ItemList.car: list is zero length");
        }
        return (Item)this.elements.get(0);
    }

    public ItemList cdr() {
        if (this.elements.size() == 0) {
            throw new ItemException("ItemList.cdr: list is zero length");
        }
        ItemList x = new ItemList(super.getLine(), super.getColumn());
        if (this.elements.size() == 0) {
            return x;
        }
        x.elements = this.elements.subList(1, this.size());
        return x;
    }

    public String shortString() {
        if (this.size() == 0) {
            return "()";
        }
        if (this.get(0).isSymbol()) {
            if (this.size() == 1) {
                return "(" + this.get(0).getSymbol() + ")";
            }
            return "(" + this.get(0).getSymbol() + " ...)";
        }
        return "(...)";
    }

    public String toString() {
        String str2 = "";
        if (this.hasLocation()) {
            str2 = str2.concat(this.location());
        }
        return str2 + this.elements.toString();
    }
}

