% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SystemMetadata.R
\docType{methods}
\name{hasAccessRule}
\alias{hasAccessRule}
\alias{hasAccessRule,SystemMetadata-method}
\title{Determine if a particular access rules exists within SystemMetadata.}
\usage{
hasAccessRule(x, ...)

\S4method{hasAccessRule}{SystemMetadata}(x, subject, permission)
}
\arguments{
\item{x}{the SystemMetadata instance to which to add the rules}

\item{...}{Additional arguments}

\item{subject}{the subject of the rule to be checked}

\item{permission}{the permission to be applied to subject if x is character}
}
\value{
A logical value: if TRUE the access rule was found, if FALSE it was not found.

boolean TRUE if the access rule exists already, FALSE otherwise
}
\description{
Each SystemMetadata document may contain a set of (subject, permission) tuples
that represent the access rules for its associated object. This method determines
whether a particular access rule already exists within the set.
}
\examples{
sysmeta <- new("SystemMetadata")
sysmeta <- addAccessRule(sysmeta, "uid=smith,ou=Account,dc=example,dc=com", "write")
accessRules <- data.frame(subject=c("uid=smith,ou=Account,dc=example,dc=com", 
  "uid=slaughter,o=unaffiliated,dc=example,dc=org"), permission=c("write", "changePermission"))
sysmeta <- addAccessRule(sysmeta, accessRules)
ruleExists <- hasAccessRule(sysmeta, subject="uid=smith,ou=Account,dc=example,dc=com", 
  permission="write")
}
\seealso{
\code{\link{SystemMetadata-class}}
}

