% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataObject.R
\docType{methods}
\name{initialize,DataObject-method}
\alias{initialize,DataObject-method}
\alias{DataObject-initialize}
\title{Initialize a DataObject}
\usage{
\S4method{initialize}{DataObject}(.Object, id = as.character(NA),
  dataobj = NA, format = as.character(NA), user = as.character(NA),
  mnNodeId = as.character(NA), filename = as.character(NA),
  seriesId = as.character(NA), mediaType = as.character(NA),
  suggestedFilename = as.character(NA), mediaTypeProperty = list())
}
\arguments{
\item{.Object}{the DataObject instance to be initialized}

\item{id}{the identifier for the DataObject, unique within its repository. Optionally this can be an existing SystemMetadata object}

\item{dataobj}{the bytes of the data for this object in \code{'raw'} format, optional if \code{'filename'} is provided}

\item{format}{the format identifier for the object, e.g."text/csv", "eml://ecoinformatics.org/eml-2.1.1"}

\item{user}{the identity of the user owning the package, typically in X.509 format}

\item{mnNodeId}{the node identifier for the repository to which this object belongs.}

\item{filename}{the filename for the fully qualified path to the data on disk, optional if \code{'data'} is provided}

\item{seriesId}{A unique string to identifier the latest of multiple revisions of the object.}

\item{mediaType}{The When specified, indicates the IANA Media Type (aka MIME-Type) of the object. The value should include the media type and subtype (e.g. text/csv).}

\item{suggestedFilename}{A suggested filename to use when this object is serialized. If not specified, defaults to the basename of the filename parameter.}

\item{mediaTypeProperty}{A list, indicates IANA Media Type properties to be associated with the parameter \code{"mediaType"}}
}
\description{
When initializing a DataObject using passed in data, one can either pass 
in the \code{'id'} param as a \code{'SystemMetadata'} object, or as a \code{'character'} string 
representing the identifier for an object along with parameters for format, user,and associated member node.
If \code{'data'} is not missing, the \code{'data'} param holds the \code{'raw'} data.  Otherwise, the
\code{'filename'} parameter must be provided, and points at a file containing the bytes of the data.
}
\details{
If filesystem storage is used for the data associated with a DataObject, care must be
taken to not modify or remove that file in R or via other facilities while the DataObject exists in the R session.
Changes to the object are not detected and will result in unexpected results.
}
\examples{
data <- charToRaw("1,2,3\\n4,5,6\\n")
do <- new("DataObject", "id1", dataobj=data, "text/csv", 
  "uid=jones,DC=example,DC=com", "urn:node:KNB")
}
\seealso{
\code{\link{DataObject-class}}
}
