% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataPackage.R
\docType{methods}
\name{getRelationships}
\alias{getRelationships}
\alias{getRelationships,DataPackage-method}
\title{Retrieve relationships of package objects}
\usage{
getRelationships(x, ...)

\S4method{getRelationships}{DataPackage}(x, condense = F, ...)
}
\arguments{
\item{x}{A DataPackage object}

\item{...}{(Not yet used)}

\item{condense}{A logical value, if TRUE then a more easily viewed version of ralationships are returned.}
}
\description{
Relationships of objects in a package are defined using the \code{'insertRelationship'} call and retrieved
using \code{getRetaionships}. These relationships are returned in a data frame with \code{'subject'}, \code{'predicate'}, \code{'objects'}
as the columns, ordered by "subject"
}
\examples{
dp <- new("DataPackage")
insertRelationship(dp, "/Users/smith/scripts/genFields.R",
    "http://www.w3.org/ns/prov#used",
    "https://knb.ecoinformatics.org/knb/d1/mn/v1/object/doi:1234/_030MXTI009R00_20030812.40.1")
rels <- getRelationships(dp)
}
\seealso{
\code{\link{DataPackage-class}}
}
