% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contributors.R
\name{new_contributor}
\alias{new_contributor}
\alias{dp_add_contributor}
\alias{dp_add_contributor<-}
\title{Creating and Adding Contributors to a Data Package}
\usage{
new_contributor(
  title,
  role = c("contributor", "author", "publisher", "maintainer", "wrangler"),
  path = NULL,
  email = NULL,
  organisation = NULL
)

dp_add_contributor(x, contributor)

dp_add_contributor(x) <- value
}
\arguments{
\item{title}{A length 1 character vector with the full nam of the
contributor.}

\item{role}{The role of the contributor}

\item{path}{A URL to e.g. a home page of the contributor}

\item{email}{The email address of the contributor}

\item{organisation}{The orgination the contributor belongs to.}

\item{x}{The Data Package to which the contributor has to be added.}

\item{contributor}{a contributor object}

\item{value}{a contributor object}
}
\value{
\code{new_contributor} returns a list with the given properties. This function
is meant to assist in creating valid contributors.
}
\description{
Creating and Adding Contributors to a Data Package
}
\examples{
dp <- open_datapackage(system.file(package = "datapackage", "examples/iris")) 
dp_contributors(dp)
dp_contributors(dp) <- list(
  new_contributor("John Doe", email = "j.doe@somewhere.org"),
  list(title = "Jane Doe", role = "maintainer")
)
dp_add_contributor(dp) <- new_contributor("Janet Doe")

}
