% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acc_loess.R
\name{acc_loess}
\alias{acc_loess}
\title{Smoothes and plots adjusted longitudinal measurements}
\usage{
acc_loess(
  resp_vars,
  group_vars,
  time_vars,
  co_vars = NULL,
  min_obs_in_subgroup,
  label_col = NULL,
  study_data,
  meta_data,
  resolution = 180,
  se_line = list(color = "red", linetype = 2),
  plot_data_time,
  plot_format = "AUTO"
)
}
\arguments{
\item{resp_vars}{\link{variable} the name of the continuous measurement variable}

\item{group_vars}{\link{variable} the name of the observer, device or reader
variable}

\item{time_vars}{\link{variable} a variable identifying the variable with the time
of measurement}

\item{co_vars}{\link{variable list} a vector of covariables, e.g. age and sex for
adjustment. Can be NULL (default) for no
adjustment.}

\item{min_obs_in_subgroup}{\link{integer} from=0. optional argument if
\code{group_vars} are used. This argument
specifies the minimum number of observations
that is required to include a subgroup
(level) of the group variable named by
\code{group_vars} in the analysis. Subgroups
with less observations are excluded. The
default is \code{30}.}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{resolution}{\link{numeric} how many timepoints have a standard error
estimation}

\item{se_line}{\link{list} standard error estimator line style, as arguments
passed to \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}}

\item{plot_data_time}{\link{logical} mark times with data values (caution, there
may be many marks)}

\item{plot_format}{\link{enum} AUTO | COMBINED | FACETS | BOTH. Return the
LOESS plot as a combined plot or as facets plots
one per group. BOTH will return both plot variants,
AUTO will decide based on the number of observers.}
}
\value{
a \link{list} with:
\itemize{
\item \code{SummaryPlotList}: list with two plots:
\itemize{
\item \code{Loess_fits_facets}: ggplot2 LOESS plot provides panels for each
subject/object. The plot contains LOESS-smoothed curves
for each level of the group_vars. The red dashed lines represent the
confidence interval of a LOESS curve for the whole data.
\item \code{Loess_fits_combined}: ggplot2 LOESS plot combines all curves into one
panel and is obtained by \code{myloess$Loess_fits_combined}. Given a low
number of levels in the group_vars
this plot eases comparisons. However, if number increases this plot may
be too crowded and unclear.
}
}
}
\description{
The following R implementation executes calculations for quality indicator
Unexpected distribution wrt location (link). Local regression (LOESS) is a
versatile statistical method to explore an averaged course of time series
measurements (Cleveland, Devlin, and Grosse 1988). In context of
epidemiological data, repeated measurements using the same measurement
device or by the same examiner can be considered a time series. LOESS allows
to explore changes in these measurements over time.
}
\details{
If \code{plot_data_time} is not set, it will be selected based on the number of
data points per group: If more than 4000 points would be plotted for at least
one group, the > 4000 marks will not be plotted.

Limitations

The application of LOESS usually requires model fitting, i.e. the smoothness
of a model is subject to a smoothing parameter (span).
Particularly in the presence of interval-based missing data (\code{USR_181}), high
variability of measurements combined with a low number of
observations in one level of the group_vars the fit to the data may be
distorted. Since our approach handles data without knowledge
of such underlying characteristics, finding the best fit is complicated if
computational costs should be minimal. The default of
LOESS in R uses a span 0.75 which provides in most cases reasonable fits. The
function above increases the fit to the data automatically
if the minimum of observations in one level of the group_vars is higher than
\code{n=30}.
}
\seealso{
\href{https://dataquality.ship-med.uni-greifswald.de/VIN_acc_impl_loess.html}{Online Documentation}
}
