% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_sts_element_dataframe.R
\name{int_sts_element_dataframe}
\alias{int_sts_element_dataframe}
\title{Determine missing and/or superfluous data elements}
\usage{
int_sts_element_dataframe(study_data, meta_data = "item_level")
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}
}
\value{
\link{list} with names lots:
\itemize{
\item \code{DataframeData}: data frame with the unexpected elements check results.
\item \code{DataframeTable}: \link{data.frame} table with all errors, used for the data quality report:
- \code{MISSING}: \code{meta_data} or \code{study_data}: where is
the element missing
- \code{PCT_int_sts_element}: Percentage of element
mismatches
- \code{NUM_int_sts_element}: Number of element
mismatches
- \code{resp_vars}: affected element names
}
}
\description{
Depends on \code{dataquieR.RECORD_MISSMATCH_CHECKTYPE} option,
see there -- # TODO: Rename this option and find out, how to document and link
it here using \code{Roxygen}.
}
