% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_check_meta_data_segment.R
\name{prep_check_meta_data_segment}
\alias{prep_check_meta_data_segment}
\title{Verify and normalize meta data on segment level}
\usage{
prep_check_meta_data_segment(meta_data_segment = "segment_level")
}
\arguments{
\item{meta_data_segment}{\link{data.frame} data frame or path/url of a metadata
sheet for the segment level}
}
\value{
standardized metadata sheet as data frame
}
\description{
if possible, mismatching data types are converted (\code{"true"} becomes \code{TRUE})
}
\details{
missing columns are added, filled with \code{NA}, if this is valid, i.e., n.a.
for \code{STUDY_SEGMENT} as the key column
}
\examples{
\dontrun{
mds <- prep_check_meta_data_segment("ship_meta_v2|segment_level") # also converts
print(mds)
prep_check_meta_data_segment(mds)
mds1 <- mds
mds1$SEGMENT_RECORD_COUNT <- NULL
print(prep_check_meta_data_segment(mds1)) # fixes the missing column by NAs
mds1 <- mds
mds1$SEGMENT_UNIQUE_ROWS[[2]] <- "xxx" # not convertible
# print(prep_check_meta_data_segment(mds1)) # fail
}
}
