% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_prep_proportion_check.R
\name{util_prep_proportion_check}
\alias{util_prep_proportion_check}
\title{Utility function to prepare the metadata for proportion checks}
\usage{
util_prep_proportion_check(
  resp_vars,
  meta_data,
  ds1,
  report_problems = c("error", "warning", "message"),
  label_col = attr(ds1, "label_col")
)
}
\arguments{
\item{resp_vars}{\link{variable list} the names of the measurement variables}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{ds1}{\link{data.frame} the data frame that contains the measurements
(hint: missing value codes should be excluded,
so the function should be called with \code{ds1}, if
available)}

\item{report_problems}{\link{enum} Should missing metadata information be reported
as error, warning or message?}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}
}
\value{
a \link{list} with the expected range for the proportion check
}
\description{
Utility function to prepare the metadata for proportion checks
}
\seealso{
Other lookup_functions: 
\code{\link{util_prep_location_check}()},
\code{\link{util_variable_references}()}
}
\concept{lookup_functions}
\concept{metadata_management}
\keyword{internal}
