% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C3FURV.R
\name{climatic_outliers}
\alias{climatic_outliers}
\title{Climatic outliers test}
\usage{
climatic_outliers(
  Data,
  meta = NULL,
  outpath,
  IQR = NA,
  bplot = FALSE,
  outfile = NA,
  ...
)
}
\arguments{
\item{Data}{A character string giving the path of the input file,
or a matrix with 5 (7) columns for daily (sub-daily) data: variable code, year, 
month, day, (hour), (minute), value.}

\item{meta}{A character vector with 6 elements: station ID, latitude, longitude,
altitude, variable code, units. If \code{Data} is a path, \code{meta} is
ignored.}

\item{outpath}{Character string giving the path for the QC results.}

\item{IQR}{Interquantile range used to define outliers. By default it is 5 for
precipitation, 3 for air temperature, and 4 for any other variable.}

\item{bplot}{If TRUE, create a boxplot and print it into a PDF.}

\item{outfile}{Filename for the plot. Ignored if \code{bplot} is FALSE.}

\item{...}{Graphical parameters passed to the function \code{\link{boxplot}}.}
}
\description{
Considers as outliers all values falling outside a range between,
for example, p25 - 3 interquartile ranges and p75 + 3 interquartile 
The number of interquantile ranges can be modified through the parameter
\code{IQR}.
}
\details{
The input file must follow the Copernicus Station Exchange 
Format (SEF). This function works with any numerical variable.

Zeroes are automatically excluded in bounded variables such as precipitation.
}
\examples{
climatic_outliers(Rosario$Tn, Meta$Tn, outpath = tempdir(), IQR = 4)

}
\author{
Alba Gilabert, Yuri Brugnara
}
