% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeletePredictJob.R
\name{DeletePredictJob}
\alias{DeletePredictJob}
\title{Function to delete one predict job from the DataRobot queue}
\usage{
DeletePredictJob(project, predictJobId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{predictJobId}{integer. Id identifying the prediction job
created by the call to \code{RequestPredictionsForDataset}.}
}
\value{
Logical TRUE and displays a message to the user if the delete
request was successful; otherwise, execution halts and an error message
is displayed.
}
\description{
This function deletes the predict job specified by predictJobId from
the DataRobot queue.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  initialJobs <- GetPredictJobs(project)
  job <- initialJobs[[1]]
  predictJobId <- job$predictJobId
  DeletePredictJob(projectId, predictJobId)
}
}
