% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deployment.R
\name{CreateDeployment}
\alias{CreateDeployment}
\title{Create a deployment.}
\usage{
CreateDeployment(
  model,
  label = "",
  description = "",
  defaultPredictionServerId = NULL
)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModel, or each element of the list returned by
the function ListModels.}

\item{label}{character. The name of the deployment.}

\item{description}{character. Optional. A longer description of the deployment.}

\item{defaultPredictionServerId}{character. The ID of the prediction server to connect to.
Can also be a prediction server object.}
}
\value{
A DataRobotDeployment object containing:
\itemize{
 \item id character. The ID of the deployment.
 \item label character. The label of the deployment.
 \item description character. The description of the deployment.
 \item defaultPredictionServer list. Information on the default prediction
   server connected with the deployment. See \code{ListPredictionServers}
   for details.
 \item model dataRobotModel. The model associated with the deployment.
   See \code{GetModel} for details.
 \item capabilities list. Information on the capabilities of the deployment.
 \item predictionUsage list. Information on the prediction usage of the deployment.
 \item serviceHealth list. Information on the service health of the deployment.
 \item modelHealth list. Information on the model health of the deployment.
 \item accuracyHealth list. Information on the accuracy health of the deployment.
}
}
\description{
Create a deployment.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  predictionServer <- ListPredictionServers()[[1]]
  CreateDeployment(model,
                   label = "myDeployment",
                   description = "this is my deployment",
                   defaultPredictionServerId = predictionServer)
}
}
