% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StartRetryWaiter.R
\name{StartRetryWaiter}
\alias{StartRetryWaiter}
\title{Creates a waiter function that can be used in a loop while trying some task many times.
The waiter sleeps while waiting to try again, with sleep times determined by exponential
back-off.}
\usage{
StartRetryWaiter(timeout = NULL, delay = 0.1, maxdelay = 1)
}
\arguments{
\item{timeout}{integer. How long (in seconds) to keep trying before timing out (NULL means no
timeout)}

\item{delay}{integer. Initial delay between tries (in seconds).}

\item{maxdelay}{integer. Maximum delay (in seconds) between tries.}
}
\value{
function which gets the waiter status. This function returns a list with these items:
/itemize{
   /item index numeric. How many times we have waited.
   /item secondsWaited numeric. How long (in seconds) since we started the timer.
   /item stillTrying logical. Whether we should keep trying or give up (logical)
}
}
\description{
Creates a waiter function that can be used in a loop while trying some task many times.
The waiter sleeps while waiting to try again, with sleep times determined by exponential
back-off.
}
