% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResidualsChart.R
\name{GetResidualsChart}
\alias{GetResidualsChart}
\title{Retrieve residuals chart data for a model for a data partition (see DataPartition).}
\usage{
GetResidualsChart(
  model,
  source = DataPartition$VALIDATION,
  fallbackToParentInsights = FALSE
)
}
\arguments{
\item{model}{dataRobotModel. A DataRobot model object like that returned by \code{GetModel}. The model
must be a regression model that is not time-aware.}

\item{source}{character. The data partition for which data would be returned. Default is
\code{DataPartition$VALIDATION}. See \code{DataPartition} for details.}

\item{fallbackToParentInsights}{logical. If TRUE, this will return the residuals chart data for
the model's parent if the residuals chart is not available for the model and the model has a
parent model.}
}
\value{
list with a single object containing residuals chart data whose name matches the source
requested. See \code{DataPartition} for details. This object has the following components:
\itemize{
\item residualMean. Numeric: the arithmetic mean of the predicted value minus the actual value
over the downsampled dataset.
\item coefficientOfDetermination. Numeric: aka the r-squared value. This value is calculated
over the downsampled output, not the full input.
\item data. data.frame:  The rows of chart data in \verb{[actual, predicted, residual, rowNumber]}
form. If the row number was not available at the time of model creation, or if working with
DataRobot 5.2, which does not provide rowNumber in the API response, the rowNumber will be
NA.
\item histogram. list: Data to plot a histogram of residual values. Each object contains:
\itemize{
\item intervalStart. Numeric: Start value for an interval, inclusive.
\item intervalEnd. Numeric: End value for an interval, exclusive for all but the last
interval.
\item occurrences. Integer: the number of times the predicted value fits within the
interval.
}
}
}
\description{
Retrieve residuals chart data for a model for a data partition (see DataPartition).
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  GetResidualsChart(model, source = DataPartition$VALIDATION)
}
}
