% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{language}
\alias{language}
\alias{language<-}
\title{Get/set the primary language of the dataset}
\usage{
language(x)

language(x, iso_639_code = "639-3") <- value
}
\arguments{
\item{x}{A semantically rich data frame object created by
\code{\link{dataset_df}} or \code{\link{as_dataset_df}}.}

\item{iso_639_code}{Defaults to \code{ISO 639-3}, alternative is \code{ISO
639-1}.}

\item{value}{The language to be added to the object attributes, added by
name, or as a 2- or 3-character code for the language. You can add a
language code or language name, and the parameter is normalized to
\code{tolower(language)}. (The ISO 639 standard capitalizes language names
and uses lower case for the codes.)}
}
\value{
The Language is added to the \code{x} as \code{ISO 639-1}, the
Datacite recommendation, or \code{ISO 639-3} used by the Zenodo data
repository.
}
\description{
Add the optional Language property as an attribute to an R
object.
}
\details{
Language is an optional property in DataCite 4.4; see:
\href{https://support.datacite.org/docs/datacite-metadata-schema-v44-recommended-and-optional-properties#9-language}{datacite:Language}\cr
It is a part of the "core" of the
\href{https://www.dublincore.org/specifications/dublin-core/dcmi-terms/}{Dublin
Core metadata terms}. The language parameter is validated against the
\code{[ISOcodes]{ISO_639_2}} table.\cr The attribute \code{language} is
added to the object. It will be exported into DataCite applications in a
capitalized \code{Lanugage} format.
}
\examples{
myorange <- orange_df
language(myorange) <- "English"
language(myorange)
language(myorange) <- "fr"
language(myorange)
}
\seealso{
Other Reference metadata functions: 
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{identifier}()},
\code{\link{publication_year}()},
\code{\link{publisher}()},
\code{\link{rights}()}
}
\concept{Reference metadata functions}
