% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_jsonld.R
\name{write_jsonld}
\alias{write_jsonld}
\title{Write a list out as object to JSON-LD}
\usage{
write_jsonld(
  x,
  path,
  context = "http://schema.org",
  pretty = TRUE,
  auto_unbox = TRUE,
  ...
)
}
\arguments{
\item{x}{an object to be serialized to JSON}

\item{path}{file on disk}

\item{context}{JSON-LD context; "http://schema.org"}

\item{pretty}{adds indentation whitespace to JSON output. Can be TRUE/FALSE or a number specifying the number of spaces to indent. See \code{\link[jsonlite]{prettify}}}

\item{auto_unbox}{automatically \code{\link[jsonlite]{unbox}} all atomic vectors of length 1. It is usually safer to avoid this and instead use the \code{\link[jsonlite]{unbox}} function to unbox individual elements.
An exception is that objects of class \code{AsIs} (i.e. wrapped in \code{I()}) are not automatically unboxed. This is a way to mark single values as length-1 arrays.}

\item{...}{additional conversion arguments, see also \link[jsonlite]{toJSON} or \link[jsonlite]{fromJSON}}
}
\description{
Write a list out as object to JSON-LD
}
