% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dataframe.R
\name{get_dataframe_by_name}
\alias{get_dataframe_by_name}
\alias{get_dataframe_by_id}
\alias{get_dataframe_by_doi}
\title{Download dataverse file as a dataframe}
\usage{
get_dataframe_by_name(
  filename,
  dataset = NULL,
  .f = NULL,
  original = FALSE,
  ...
)

get_dataframe_by_id(fileid, .f = NULL, original = FALSE, ...)

get_dataframe_by_doi(filedoi, .f = NULL, original = FALSE, ...)
}
\arguments{
\item{filename}{The name of the file of interest, with file extension, for example
\code{"roster-bulls-1996.tab"}.}

\item{dataset}{A character specifying a persistent identification ID for a dataset,
for example \code{"doi:10.70122/FK2/HXJVJU"}. Alternatively, an object of class
\dQuote{dataverse_dataset} obtained by \code{dataverse_contents()}.}

\item{.f}{The function to used for reading in the raw dataset. This user
must choose the appropriate function: for example if the target is a .rds
file, then \code{.f} should be \code{readRDS} or \code{readr::read_rds}.}

\item{original}{A logical, defaulting to TRUE. Whether to read the ingested,
archival version of the datafile if one exists. The archival versions are tab-delimited
\code{.tab} files so if \code{original = FALSE}, \code{.f} is set to \code{readr::read_tsv}.
If functions to read the original version is available, then \code{original = TRUE}
with a specified \code{.f} is better.}

\item{...}{
  Arguments passed on to \code{\link[=get_file]{get_file}}
  \describe{
    \item{\code{file}}{An integer specifying a file identifier; or a vector of integers
specifying file identifiers; or, if used with the prefix \code{"doi:"}, a
character with the file-specific DOI; or, if used without the prefix, a
filename accompanied by a dataset DOI in the \code{dataset} argument, or an object of
class \dQuote{dataverse_file} as returned by \code{\link{dataset_files}}.}
    \item{\code{format}}{A character string specifying a file format for download.
by default, this is \dQuote{original} (the original file format). If \code{NULL},
no query is added, so ingested files are returned in their ingested TSV form.
For tabular datasets, the option \dQuote{bundle} downloads the bundle
of the original and archival versions, as well as the documentation.
See \url{https://guides.dataverse.org/en/latest/api/dataaccess.html} for details.}
    \item{\code{vars}}{A character vector specifying one or more variable names, used to
extract a subset of the data.}
    \item{\code{key}}{A character string specifying a Dataverse server API key. If one
is not specified, functions calling authenticated API endpoints will fail.
Keys can be specified atomically or globally using
\code{Sys.setenv("DATAVERSE_KEY" = "examplekey")}.}
    \item{\code{server}}{A character string specifying a Dataverse server. There are
multiple Dataverse installations, but the defaults is to use the Harvard
Dataverse (\code{server = "dataverse.harvard.edu"}). This can be modified atomically
or globally using \code{Sys.setenv("DATAVERSE_SERVER" = "dataverse.example.com")}.}
  }}

\item{fileid}{A numeric ID internally used for \code{get_file_by_id}}

\item{filedoi}{A DOI for a single file (not the entire dataset), of the form
\code{"10.70122/FK2/PPIAXE/MHDB0O"} or \code{"doi:10.70122/FK2/PPIAXE/MHDB0O"}}
}
\description{
Use \code{get_dataframe_by_name} if you know the name of the datafile and the DOI
of the dataset. Use \code{get_dataframe_by_doi} if you know the DOI of the datafile
itself. Use \code{get_dataframe_by_id} if you know the numeric ID of the
datafile.
}
\examples{
# Retrieve data.frame from dataverse DOI and file name
df_tab <-
  get_dataframe_by_name(
    filename = "roster-bulls-1996.tab",
    dataset  = "doi:10.70122/FK2/HXJVJU",
    server   = "demo.dataverse.org"
  )

# Retrieve the same file from file DOI
df_tab <-
  get_dataframe_by_doi(
    filedoi      = "10.70122/FK2/HXJVJU/SA3Z2V",
    server       = "demo.dataverse.org"
  )

# Do not run when submitting to CRAN, because the whole
# example sometimes takes longer than 10 sec.
\dontrun{
# Retrieve ingested file originally a Stata dta
df_from_stata_ingested <-
  get_dataframe_by_name(
    filename   = "nlsw88.tab",
    dataset    = "doi:10.70122/FK2/PPIAXE",
    server     = "demo.dataverse.org"
  )

# To use the original file version, or for non-ingested data,
# please specify `original = TRUE` and specify a function in .f.

if (requireNamespace("readr", quietly = TRUE)) {
  df_from_rds_original <-
    get_dataframe_by_name(
      filename   = "nlsw88_rds-export.rds",
      dataset    = "doi:10.70122/FK2/PPIAXE",
      server     = "demo.dataverse.org",
      original   = TRUE,
      .f         = readr::read_rds
    )
}

# Get Stata file as original
if (requireNamespace("haven", quietly = TRUE)) {
  df_stata_original <-
    get_dataframe_by_name(
      filename   = "nlsw88.tab",
      dataset    = "doi:10.70122/FK2/PPIAXE",
      server     = "demo.dataverse.org",
      original   = TRUE,
      .f         = haven::read_dta
    )
}

# Stata file as ingested file (less information than original)
df_stata_ingested <-
  get_dataframe_by_name(
    filename   = "nlsw88.tab",
    dataset    = "doi:10.70122/FK2/PPIAXE",
    server     = "demo.dataverse.org"
 )

}

}
