% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_backups.R
\name{get_backups}
\alias{get_backups}
\title{Get backups}
\usage{
get_backups(destination, collect = TRUE)
}
\arguments{
\item{destination}{a local directory path or an arrow SubTreeFileSystem}

\item{collect}{should we collect the underlying arrow dataset or return just the connection?}
}
\value{
an arrow dataset
}
\description{
Read the backups in a versioned dataset to a data frame or an arrow dataset
}
\examples{
temp_dir <- tempfile()
dir.create(temp_dir, recursive = TRUE)
df <- data.frame(a = 1:5, b = letters[1:5])
put_backup(df, temp_dir)


get_backups(temp_dir)

}
