% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrations_use.R
\name{use_all_calibrations}
\alias{use_all_calibrations}
\title{Date a given tree topology using a given set of calibrations}
\usage{
use_all_calibrations(
  phy = NULL,
  calibrations = NULL,
  each = FALSE,
  dating_method = "bladj",
  ...
)
}
\arguments{
\item{phy}{A \code{phylo} object to use as tree topology.}

\item{calibrations}{A \code{datelifeCalibrations} object, an output of \code{\link[=get_all_calibrations]{get_all_calibrations()}}.}

\item{each}{Boolean, default to \code{FALSE}: all calibrations are returned in
the same \code{data.frame}. If \code{TRUE}, calibrations from each chronogram are returned
in separate data frames.}

\item{dating_method}{Tree dating algorithm to use. Options are "bladj" or "pathd8"
(Webb et al., 2008, \doi{10.1093/bioinformatics/btn358}; Britton et al., 2007,
\doi{10.1080/10635150701613783}).}

\item{...}{
  Arguments passed on to \code{\link[=use_calibrations]{use_calibrations}}
  \describe{
    \item{\code{type}}{The type of age to use as calibration. Options are "median", "mean", "min", or "max".}
  }}
}
\value{
A \code{phylo} or \code{multiPhylo} object with branch lengths proportional to time.
}
\description{
\code{use_all_calibrations} generates one or multiple chronograms
(i.e., phylogenetic trees with branch lengths proportional to time) by dating
a tree topology given in \code{phy}, and secondary calibrations given in
\code{calibrations}, using the algorithm specified in the argument \code{dating_method}.
}
\details{
If \code{phy} has no branch lengths, \code{dating_method} is ignores, and the function applies secondary
calibrations to date the tree with the BLADJ algorithm. See \code{\link[=make_bladj_tree]{make_bladj_tree()}} and \code{\link[=use_calibrations_bladj]{use_calibrations_bladj()}}.
If \code{phy} has branch lengths, the function can use the PATHd8 algorithm. See \code{\link[=use_calibrations_pathd8]{use_calibrations_pathd8()}}.
}
\section{output}{
 The output object stores the used \code{calibrations} and \code{dating_method} as
\code{attributes(output)$datelife_calibrations} and \code{attributes(output)$dating_method}.
}

\references{
Webb, C. O., Ackerly, D. D., & Kembel, S. W. (2008). "Phylocom: software for
the analysis of phylogenetic community structure and trait evolution".
Bioinformatics, 24(18), \doi{10.1093/bioinformatics/btn358}.

Britton, T., Anderson, C. L., Jacquet, D., Lundqvist, S., & Bremer, K. (2007).
"Estimating divergence times in large phylogenetic trees". Systematic biology,
56(5), 741-752. \doi{10.1080/10635150701613783}.
}
