% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_calibrations_bladj_matched.R
\name{use_calibrations_bladj.matchedCalibrations}
\alias{use_calibrations_bladj.matchedCalibrations}
\title{Use calibrations to date a topology with the BLADJ algorithm.}
\usage{
use_calibrations_bladj.matchedCalibrations(
  calibrations,
  type = "mean",
  root_age = NULL
)
}
\arguments{
\item{calibrations}{A \code{data.frame} of secondary calibrations for any pair of taxon
names in \code{phy}, usually obtained with \code{\link[=get_all_calibrations]{get_all_calibrations()}}.}

\item{type}{The type of age to use as calibration. Options are "median", "mean", "min", or "max".}

\item{root_age}{Numeric specifying an age for the root, provided by the user.
Only used if there are no time calibrations for the root node in the chronograms database.
If \code{NULL} or not numeric, the maximum calibration age plus one unit of the sd
(calculated with \code{\link[stats:sd]{stats::sd()}})
of all node ages available for the tree will be used as root calibration.
If there is only one calibration available for the whole tree, the root
node age will be proportional to 1.1 of the age of that calibration.}
}
\value{
A \code{phylo} object with branch lengths proportional to time.
}
\description{
The function prepares the input for BLADJ and calls \code{\link[=make_bladj_tree]{make_bladj_tree()}}
}
\details{
The BLADJ algorithm is part of the Phylocom software, presented in Webb et al.
(2008) \doi{10.1093/bioinformatics/btn358}.
}
\references{
Webb, C. O., Ackerly, D. D., & Kembel, S. W. (2008). "Phylocom: software for
the analysis of phylogenetic community structure and trait evolution".
Bioinformatics, 24(18), \doi{10.1093/bioinformatics/btn358}.
}
