% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{nat_vel_plus_vel_cpp}
\alias{nat_vel_plus_vel_cpp}
\title{Adds two natVelocities}
\usage{
nat_vel_plus_vel_cpp(vl1, vl1_neg, vl2, vl2_neg, abs_op1, abs_op2)
}
\arguments{
\item{vl1}{the first Velocity's positive part}

\item{vl1_neg}{the first Velocity's negative part}

\item{vl2}{the second Velocity's positive part}

\item{vl2_neg}{the first Velocity's negative part}

\item{abs_op1}{the number of {1,-1} operations in the first velocity}

\item{abs_op2}{the number of {1,-1} operations in the second velocity}
}
\value{
the total number of resulting operations
}
\description{
Adds two natVelocities represented as two numeric vectors: one with the
positive part and one with the negative part. Adding them is a process that
does a bitwise 'or' with both the positive and negative parts of the two
velocities, adjusts the new abs_op, removes duplicated arcs in the final
velocity by using a bitwise 'xor' with both parts and adjusts the final abs_op.
The results are returned via modifying the original vl1 and vl1_neg by
reference and returning the final abs_op normally. I can't have an integer
edited by reference because it automatically gets casted and cannot be used
to return values.
}
