% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete.R
\name{dbplot_bar}
\alias{dbplot_bar}
\title{Bar plot}
\usage{
dbplot_bar(data, x, y = n())
}
\arguments{
\item{data}{A table (tbl)}

\item{x}{A discrete variable}

\item{y}{The aggregation formula. Defaults to count (n)}
}
\description{
Uses very generic dplyr code to aggregate data and then `ggplot2` 
to create the plot.  Because of this approach,
the calculations automatically run inside the database if `data` has
a database or sparklyr connection. The `class()` of such tables
in R are: tbl_sql, tbl_dbi, tbl_spark
}
\examples{

library(ggplot2)

# Returns a plot of the row count per am 
mtcars \%>\%
  dbplot_bar(am)

# Returns a plot of the average mpg per am
mtcars \%>\%
  dbplot_bar(am, mean(mpg))

}
\seealso{
\code{\link{dbplot_line}} ,
\code{\link{dbplot_histogram}},  \code{\link{dbplot_raster}} ,
}
