% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogram.R
\name{db_compute_bins}
\alias{db_compute_bins}
\title{Calculates a histogram bins}
\usage{
db_compute_bins(data, x, bins = 30, binwidth = NULL)
}
\arguments{
\item{data}{A table (tbl)}

\item{x}{A continuous variable}

\item{bins}{Number of bins. Defaults to 30.}

\item{binwidth}{Single value that sets the side of the bins, it overrides bins}
}
\description{
Uses very generic dplyr code to create histogram bins.
Because of this approach,
the calculations automatically run inside the database if `data` has
a database or sparklyr connection. The `class()` of such tables
in R are: tbl_sql, tbl_dbi, tbl_spark
}
\examples{

# Returns record count for 30 bins in mpg
mtcars \%>\%
  db_compute_bins(mpg)

# Returns record count for bins of size 10
mtcars \%>\%
  db_compute_bins(mpg, binwidth = 10)

}
\seealso{
\code{\link{db_bin}},
}
