% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial-eval.r
\name{partial_eval}
\alias{partial_eval}
\title{Partially evaluate an expression.}
\usage{
partial_eval(call, vars = character(), env = caller_env())
}
\arguments{
\item{call}{an unevaluated expression, as produced by \code{\link[=quote]{quote()}}}

\item{vars}{character vector of variable names.}

\item{env}{environment in which to search for local values}
}
\description{
This function partially evaluates an expression, using information from
the tbl to determine whether names refer to local expressions
or remote variables. This simplifies SQL translation because expressions
don't need to carry around their environment - all revelant information
is incorporated into the expression.
}
\section{Symbol substitution}{


\code{partial_eval()} needs to guess if you're referring to a variable on the
server (remote), or in the current environment (local). It's not possible to
do this 100% perfectly. \code{partial_eval()} uses the following heuristic:

\itemize{
\item If the tbl variables are known, and the symbol matches a tbl
variable, then remote.
\item If the symbol is defined locally, local.
\item Otherwise, remote.
}
}

\examples{
vars <- c("year", "id")
partial_eval(quote(year > 1980), vars = vars)

ids <- c("ansonca01", "forceda01", "mathebo01")
partial_eval(quote(id \%in\% ids), vars = vars)

# You can use local to disambiguate between local and remote
# variables: otherwise remote is always preferred
year <- 1980
partial_eval(quote(year > year), vars = vars)
partial_eval(quote(year > local(year)), vars = vars)

# Functions are always assumed to be remote. Use local to force evaluation
# in R.
f <- function(x) x + 1
partial_eval(quote(year > f(1980)), vars = vars)
partial_eval(quote(year > local(f(1980))), vars = vars)

# For testing you can also use it with the tbl omitted
partial_eval(quote(1 + 2 * 3))
x <- 1
partial_eval(quote(x ^ y))
}
\keyword{internal}
