% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-hana.R
\name{backend-hana}
\alias{simulate_hana}
\title{Backend: SAP HANA}
\usage{
simulate_hana()
}
\description{
See \code{vignette("translation-function")} and \code{vignette("translation-verb")} for
details of overall translation technology. Key differences for this backend
are:
\itemize{
\item Temporary tables get \verb{#} prefix and use \verb{LOCAL TEMPORARY COLUMN}.
\item No table analysis performed in \code{\link[=copy_to]{copy_to()}}.
\item \code{paste()} uses \code{||}
\item Note that you can't create new boolean columns from logical expressions;
you need to wrap with explicit \code{ifelse}: \code{ifelse(x > y, TRUE, FALSE)}.
}

Use \code{simulate_hana()} with \code{lazy_frame()} to see simulated SQL without
converting to live access database.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

lf <- lazy_frame(a = TRUE, b = 1, c = 2, d = "z", con = simulate_hana())
lf \%>\% transmute(x = paste0(z, " times"))
}
