% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dcSplitArch.r
\name{dcSplitArch}
\alias{dcSplitArch}
\title{Function to obtain a list of features via splitting an input architecture}
\usage{
dcSplitArch(da, feature.mode = c("supra", "individual", "comb"), sep =
",",
ignore = "_gap_", verbose = T)
}
\arguments{
\item{da}{an input architecture. For example, a comma-separated string}

\item{feature.mode}{the mode of how to define the features thereof. It
can be: "supra" for combinations of one or two successive domains
(including individual domains; considering the order), "individual" for
individual domains only, and "comb" for all possible combinations
(including individual domains; ignoring the order)}

\item{sep}{a character string to separate. By default, it is comma ','}

\item{ignore}{a character string to ignore. By default, it is '_gap_'.
Ihis ignored character will affect the features defined as being
'supra' (see examples below)}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to TRUE for display}
}
\value{
a vector containing splitted features.
}
\description{
\code{dcSplitArch} is supposed to obtain a list of features via
splitting an input architecture.
}
\note{
none
}
\examples{
da <- "_gap_,100895,57610,_gap_,57610,47473"
# get features defined as being "supra"
dcSplitArch(da, feature.mode="supra")
# get features defined as being "individual"
dcSplitArch(da, feature.mode="individual")
# get features defined as being "comb"
dcSplitArch(da, feature.mode="comb")
}
\seealso{
\code{\link{dcAlgo}}, \code{\link{dcAlgoPredict}}
}

