% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{dccmidas_loglik}
\alias{dccmidas_loglik}
\title{DCC-MIDAS log-likelihood (second step)}
\usage{
dccmidas_loglik(param, res, lag_fun = "Beta", N_c, K_c)
}
\arguments{
\item{param}{Vector of starting values.}

\item{res}{Array of standardized daily returns, coming from the first step estimation.}

\item{lag_fun}{\strong{optional}. Lag function to use. Valid choices are "Beta" (by default) and "Almon",
for the Beta and Exponential Almon lag functions, respectively.}

\item{N_c}{Number of (lagged) realizations to use for the standarized residuals forming the long-run correlation.}

\item{K_c}{Number of (lagged) realizations to use for the long-run correlation.}
}
\value{
The resulting vector is the log-likelihood value for each \eqn{t}.
}
\description{
Obtains the log-likelihood of the DCC models in the second step.
For details, see \insertCite{colacito2011component;textual}{dccmidas} and \insertCite{dcc_engle_2002;textual}{dccmidas}.
}
\references{
\insertAllCited{}
}
\keyword{internal}
