# Calculate posterior probability using prior as in Fröhlich 2007/Wehrli/Husmeier 2007
# or by sparsity prior
# 
# Author: benderc
###############################################################################

# sparsity prior
#posterior <- function(phi, L, lambda, B=NULL, Z=NULL, gam=2.2, it=500, K=0.8) {
posterior <- function(phi, L, lambda=NULL, B=NULL, Z=NULL, gam=NULL, it=NULL, K=NULL) {
	laplace <- !is.null(lambda) && !is.null(B) && !is.null(Z)
	sparsity <- !is.null(gam) && !is.null(it) && !is.null(K)
	if(laplace) {
		# B has same dimensions as phi, reduce phi to network with only one edge type
		EG <- sum(abs(B - detailed.to.simple.regulations(phi)))
		#PGlambda <- log2(exp(-lambda * EG)) - Z
		#PGlambda <- log2(2^(-lambda * EG)) - Z
		PGlambda <- (-lambda * EG) - Z
		post <- L + PGlambda
	} else if(sparsity) {
		post <- L + log2(pgs(phi,gam,K,it))
	} else {
		stop("posterior.R: Error - Prior information not specified correctly.")
	}
	post
}


pi <- function(i,gam,N) {
	(1-(1/(1-gam)))/(N^(1-(1/(1-gam)))) * i^(-(1/(gam-1)))
}

## phi: network
## N : number of nodes
## gam: degree distribution coefficient: P(K) ~ K^gam
## perm: permutation
pgs <- function(phi,gam,K=0.8,it=500) {
	N <- nrow(phi)
	ind <- which(phi!=0,arr.ind=TRUE)
	fixe <- exp(-N*K*(1-sum(pi(1:N,gam,N)^2)))
	res <- 0
	piN <- pi(1:N, gam, N)
	mu <- 1/(gam-1)
	for(b in 1:it) {
		perm <- sample(1:N)
		piNp <- piN[perm]
		res <- res + prod(exp(2*N*K*piNp[ind[,1]]*piNp[ind[,2]]-1)) * fixe
	}
	res <- res/it
	res
}
