#' I-V Curves from External Solar Testing Laboratory.
#'
#' These 2 IV curves are from an external solar module testing facility. 2 full sized modules are featured, a standard poly-Si AL-BSF module and a similar PERC mono-Si module. The PERC module has a clearly higher power output compared to the Al-BSF module given the higher voltage and current output with a similar fill factor.
#' This data set is a study of IV curve with 1 step. The first column is voltage(V) and the second column is current(I).
#'
#' @docType data
#' @usage data(IV_5M_1)
#' @name IV_5M_1
#'
#' @format A data frame with 478 rows and 2 variables:
#' \describe{
#'   \item{V}{increasing vector}
#'   \item{I}{decreasing vector}
#' }
#'
#' @source Solar Durability and Lifetime Extension (SDLE) Research Center, Case Western
#' Reserve University
#'
"IV_5M_1"
