% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVfeature.R
\name{IVfeature}
\alias{IVfeature}
\title{Calculate IV feature from a IV curve}
\usage{
IVfeature(I, V, crt = 0.2, num = 75, crtvalb = 0.3)
}
\arguments{
\item{I}{A vector of current values from IV data frame}

\item{V}{A vector of voltage values from IV data frame}

\item{crt}{A value to set for how large of regression coefficient change rate we use as not changing much. This is due to the value of IV curve, suggestion is to test this function with several IV curves for your data and find the proper value. The default is 0.2.}

\item{num}{A value of number of data points. The default is 75.}

\item{crtvalb}{A value to set the change of I(current) we want to use as changing very much (to detect the end of IV curve). Suggestion is to test this function with several IV curves for your data and find the proper value. The default is 0.3}
}
\value{
a list of the following items:
\itemize{
 \item "Isc": short-circuit current, which is the current through the solar cell when the voltage across the solar cell is zero.
 \item "Rsh": shunt resistance, which is the inverse slope of the IV curve near Isc.
 \item "Voc": open-circuit voltage, which is the maximum voltage from a solar cell and occurs at zero current.
 \item "Rs": series resistance, which is the inverse slope of the IV curve near Voc.
 \item "Pmp": maximum power for a solar cell/PV module.
 \item "Imp": current at maximum power.
 \item "Vmp": voltage at maximum power.
 \item "FF": fill factor, which is the ratio of maximum power from a solar cell to the product of Voc and Isc.
}
}
\description{
Calculate IV feature from the given IV curve with one step
}
\details{
Note that IV curve should have voltage ordered from the smalles value to the largest value.

This function can gives result for IV curves with more than one steps, but the results are not accurate.
To extract IV features for IV curves with more than one steps, or unsure about the steps of IV curves, please use IVExtractResult().
For IV curve has only one step, this function can be used.
}
\examples{
#this IV curve is of step=1
#if IV curve is of step>1, please use IVsteps to first find the number of
#steps and change points, then apply this function for each steps
#load the data provided in the package
data(IV_step1)
IV1 <- data.frame(IV_step1)
result <- IVfeature(IV1$I,IV1$V,crt=0.2,num=75,crtvalb=0.3)

}
