% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate-attribs.R
\name{type}
\alias{type}
\title{Plate type}
\usage{
type(plate, all = FALSE)
}
\arguments{
\item{plate}{A ddPCR plate}

\item{all}{If \code{FALSE}, show only the most specific plate type; otherwise,
show all inherited (implicit) types as well.}
}
\value{
A character vector with the plate type(s).
}
\description{
Get the type of a ddPCR plate.
\href{https://github.com/daattali/ddpcr#advanced-topic-3-creating-new-plate-types}{See the README} for more
information on plate types.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir(), type = plate_types$fam_positive_pnpp)
type(plate)
type(plate, TRUE)
}
}
\seealso{
\code{\link[ddpcr]{plate_types}}
}
