% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_DDT_functions.R
\name{simulate_parameter_on_tree}
\alias{simulate_parameter_on_tree}
\title{Simulate node parameters along a given tree.}
\usage{
simulate_parameter_on_tree(
  tree_phylo,
  Sigma_by_group,
  item_membership_list,
  root_node_location = 0
)
}
\arguments{
\item{tree_phylo}{a "phylo" object containing the tree topology and branch lengths}

\item{Sigma_by_group}{a G-vector greater than 0. The initial values for the group-specific diffusion
variances}

\item{item_membership_list}{a list of G elements, where the g-th element contains the indices of
items in major group g}

\item{root_node_location}{the coordinate of the root node parameter. By default, the node parameter
initiates at the origin so takes value 0. If a value, then the value will be repeated into a
length J vector. If a vector, it must be of length J.}
}
\value{
A class "phylo4d" tree with K leaves with node parameters. The leaf nodes are labeled "v1", ..., "vK",
root node "u1", and internal nodes "u2", ..., "uK".
}
\description{
Simulate node parameters along a given tree.
}
\examples{
library(ape)
tr_txt <- "(((v1:0.25, v2:0.25):0.65, v3:0.9):0.1);"
tree <- read.tree(text = tr_txt)
tree$node.label <- paste0("u", 1:Nnode(tree))
plot(tree, show.node.label = TRUE)
# create a list of item membership indices of 7 major groups
item_membership_list <- list()
num_items_per_group <- c(rep(10, 5), 15, 15)
G <- length(num_items_per_group)
j <- 0
for (g in 1:G) {
  item_membership_list[[g]] <- (j+1):(j+num_items_per_group[g])
  j <- j+num_items_per_group[g]
}
# variance of logit response probabilities of items in each group
Sigma_by_group <- c(rep(0.6**2, 5), rep(2**2, 2)) #rep(1**2, G)
set.seed(50)
tree_with_parameter <- simulate_parameter_on_tree(tree, Sigma_by_group, item_membership_list)
}
\seealso{
Other simulate DDT-LCM data: 
\code{\link{simulate_DDT_tree}()},
\code{\link{simulate_lcm_given_tree}()},
\code{\link{simulate_lcm_response}()}
}
\concept{simulate DDT-LCM data}
