% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_text-layer.R
\name{add_text_layer}
\alias{add_text_layer}
\title{Add a text layer to the deckgl widget}
\usage{
add_text_layer(deckgl, id = "text-layer", data = NULL,
  properties = list(), ...)
}
\arguments{
\item{deckgl}{deckgl widget}

\item{id}{id of the layer}

\item{data}{url to fetch data from or data object}

\item{properties}{named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class, additionally there is a \code{getTooltip} property (callback)
showing a tooltip when the mouse enters an object,
e. g. \code{getTooltip = JS("object => object.name")}}

\item{...}{more properties (will be added to the properties object), useful if you
want to use a properties object for more than one layer}
}
\description{
The \code{TextLayer} renders text labels on the map using texture mapping.
}
\examples{
## @knitr text-layer
data("bart_stations")

deck <- deckgl(zoom = 10, pitch = 35) \%>\%
  add_text_layer(
    data = bart_stations,
    pickable = TRUE,
    getPosition = ~lng + lat,
    getText = ~name,
    getSize = 15,
    getAngle = 0,
    getTextAnchor = "middle",
    getAlignmentBaseline = "center",
    getTooltip = JS("object =>`${object.name}<br/>${object.address}`")
  ) \%>\%
  add_mapbox_basemap()

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/text-layer}
}
