% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepel_from_EN.R
\name{deepel_from_EN}
\alias{deepel_from_EN}
\title{Translate English Text to Other Languages via DeepL API}
\usage{
deepel_from_EN(
  target_lang = "JA",
  Auth_Key = Sys.getenv("DeepL_API_KEY"),
  free_mode = TRUE
)
}
\arguments{
\item{target_lang}{The language into which the text should be translated. Options are:
   BG - Bulgarian, CS - Czech, DA - Danish, DE - German, EL - Greek,
   EN - English (unspecified variant for backward compatibility; please select EN-GB or EN-US instead),
   EN-GB - English (British), EN-US - English (American), ES - Spanish, ET - Estonian,
   FI - Finnish, FR - French, HU - Hungarian, ID - Indonesian, IT - Italian,
   JA - Japanese, KO - Korean, LT - Lithuanian, LV - Latvian, NB - Norwegian (Bokmål),
   NL - Dutch, PL - Polish, PT - Portuguese (unspecified variant for backward compatibility; please select PT-BR or PT-PT instead),
   PT-BR - Portuguese (Brazilian), PT-PT - Portuguese (all Portuguese varieties excluding Brazilian Portuguese),
   RO - Romanian, RU - Russian, SK - Slovak, SL - Slovenian, SV - Swedish,
   TR - Turkish, UK - Ukrainian, ZH - Chinese (simplified).
\code{assertthat::is.string(target_lang)}}

\item{Auth_Key}{The authentication key for the DeepL API.}

\item{free_mode}{A logical value indicating whether to use the free or paid DeepL API. Default is TRUE.}
}
\value{
The translated text is placed into the clipboard and the function returns the result of \code{clipr::write_clip}.
}
\description{
Translate English text from the clipboard into the specified target language using the DeepL API.
}
\details{
Translate English Text to Other Languages via DeepL API

This function takes English text from the clipboard and translates it into the specified target language using the DeepL API.
The translated text is then placed back into the clipboard, ready to be pasted wherever needed.
}
\examples{
\dontrun{

#Copy English text into your clipboard to excute the function. Then paste your clipboard.
deepel_from_EN(target_lang = 'JA')

}
}
\author{
Satoshi Kume
}
