% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{penalty_control}
\alias{penalty_control}
\title{Options for penalty setup in the pre-processing}
\usage{
penalty_control(
  defaultSmoothing = NULL,
  df = 10,
  null_space_penalty = FALSE,
  absorb_cons = FALSE,
  anisotropic = TRUE,
  zero_constraint_for_smooths = TRUE,
  hat1 = FALSE,
  sp_scale = function(x) 1/NROW(x)
)
}
\arguments{
\item{defaultSmoothing}{function applied to all s-terms, per default (NULL)
the minimum df of all possible terms is used. Must be a function the smooth term
from mgcv's smoothCon and an argument \code{df}.}

\item{df}{degrees of freedom for all non-linear structural terms (default = 7);
either one common value or a list of the same length as number of parameters;
if different df values need to be assigned to different smooth terms,
use df as an argument for \code{s()}, \code{te()} or \code{ti()}}

\item{null_space_penalty}{logical value;
if TRUE, the null space will also be penalized for smooth effects.
Per default, this is equal to the value give in \code{variational}.}

\item{absorb_cons}{logical; adds identifiability constraint to the basisi.
See \code{?mgcv::smoothCon} for more details.}

\item{anisotropic}{whether or not use anisotropic smoothing (default is TRUE)}

\item{zero_constraint_for_smooths}{logical; the same as absorb_cons,
but done explicitly. If true a constraint is put on each smooth to have zero mean. Can
be a vector of \code{length(list_of_formulas)} for each distribution parameter.}

\item{hat1}{logical; if TRUE, the smoothing parameter is defined by the trace of the hat
matrix sum(diag(H)), else sum(diag(2*H-HH))}

\item{sp_scale}{function of response; for scaling the penalty (1/n per default)}
}
\value{
Returns a list with options
}
\description{
Options for penalty setup in the pre-processing
}
