% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bisquare_basis.R
\name{bisquares2D}
\alias{bisquares2D}
\title{Bisquare functions on a 2D domain}
\usage{
bisquares2D(r = 30, lims = c(-0.5, 0.5), dtype = "float32")
}
\arguments{
\item{r}{30}

\item{lims}{the bounded 1D domain on which to set up the bisquare functions}

\item{dtype}{data type}
}
\value{
\code{bisquares1D} returns a list containing a list with the following components:
\describe{
 \item{"f"}{An encapsulated function that takes an input and evaluates the sigmoids over the \code{dim}-th dimension using \code{TensorFlow}}
 \item{"fR"}{Same as \code{f} but uses \code{R}}
 \item{"r"}{The number of sigmoid basis functions}
 \item{"knots_tf"}{The centroids of the basis functions as a \code{TensorFlow} object}
 \item{"knots"}{The centroids of the basis functions as an \code{R} object}
}
}
\description{
Sets up a top-layer set of bisquare basis functions on a square 2D domain of
size 1 x 1 for modelling the process \eqn{Y}. It returns a list of length 1 containing the basis functions and encapsulated
functions that evaluate the bisquare functions over inputs of different types. See Value for more details.
}
