% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepspat_main_nn_GP.R
\name{deepspat_nn_GP}
\alias{deepspat_nn_GP}
\title{Deep compositional spatial model (with nearest neighbors)}
\usage{
deepspat_nn_GP(
  f,
  data,
  g = ~1,
  layers = NULL,
  m = 25L,
  order_id,
  nn_id,
  method = c("REML"),
  family = c("exp_stat", "exp_nonstat"),
  par_init = initvars(),
  learn_rates = init_learn_rates(),
  nsteps = 150L
)
}
\arguments{
\item{f}{formula identifying the dependent variables and the spatial inputs in the covariance}

\item{data}{data frame containing the required data}

\item{g}{formula identifying the independent variables in the linear trend}

\item{layers}{list containing the nonstationary warping layers}

\item{m}{number of nearest neighbors}

\item{order_id}{indices of the order of the observations}

\item{nn_id}{indices of the nearest neighbors of the ordered observations}

\item{method}{identifying the method for finding the estimates}

\item{family}{identifying the family of the model constructed}

\item{par_init}{list of initial parameter values. Call the function \code{initvars()} to see the structure of the list}

\item{learn_rates}{learning rates for the various quantities in the model. Call the function \code{init_learn_rates()} to see the structure of the list}

\item{nsteps}{number of steps when doing gradient descent times two or three (depending on the family of model)}
}
\value{
\code{deepspat_nn_GP} returns an object of class \code{deepspat_nn_GP} with the following items
\describe{
 \item{"f"}{The formula used to construct the covariance model}
 \item{"g"}{The formula used to construct the linear trend model}
 \item{"data"}{The data used to construct the deepspat model}
 \item{"X"}{The model matrix of the linear trend}
 \item{"layers"}{The warping function layers in the model}
 \item{"Cost"}{The final value of the cost}
 \item{"eta_tf"}{Estimated weights in the warping layers as a list of \code{TensorFlow} objects}
 \item{"a_tf"}{Estimated parameters in the LFT layers}
 \item{"beta"}{Estimated coefficients of the linear trend}
 \item{"precy_tf"}{Precision of measurement error, as a \code{TensorFlow} object}
 \item{"sigma2_tf"}{Variance parameter in the covariance matrix, as a \code{TensorFlow} object}
 \item{"l_tf"}{Length scale parameter in the covariance matrix, as a \code{TensorFlow} object}
 \item{"scalings"}{Minima and maxima used to scale the unscaled unit outputs for each warping layer, as a list of \code{TensorFlow} objects}
 \item{"method"}{Method used for inference}
 \item{"nlayers"}{Number of warping layers in the model}
 \item{"swarped_tf"}{Spatial locations on the warped domain}
 \item{"negcost"}{Vector of costs after each gradient-descent evaluation}
 \item{"z_tf"}{Data of the process}
 \item{"m"}{The number of nearest neighbors}
 \item{"family"}{Family of the model}
 }
}
\description{
Constructs a deep compositional spatial model (with nearest neighbors)
}
