% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alias-deeptrafo.R
\name{ontram}
\alias{ontram}
\title{Ordinal neural network transformation models}
\usage{
ontram(
  response,
  intercept = NULL,
  shift = NULL,
  shared = NULL,
  data,
  response_type = "ordered",
  order = get_order(response_type, data[[all.vars(response)[1]]]),
  addconst_interaction = 0,
  latent_distr = "logistic",
  monitor_metrics = NULL,
  trafo_options = trafo_control(order_bsp = order, response_type = response_type),
  ...
)
}
\arguments{
\item{response}{Formula for the response; e.g., \code{~ y}}

\item{intercept}{Formula for the intercept function; e.g., \code{~ x},
for which interacting bases with the response will be set up}

\item{shift}{Formula for the shift part of the model; e.g., \code{~ s(x)}}

\item{shared}{Formula for sharing weights between predictors in the intercept
and shift part of the model}

\item{data}{Named \code{list} or \code{data.frame} which may contain both
structured and unstructured data.}

\item{response_type}{Character; type of response. One of \code{"continuous"},
\code{"survival"}, \code{"count"}, or \code{"ordered"}. If not supplied
manually it is determined by the first entry in \code{data[[response]]}.}

\item{order}{Integer; order of the response basis. Default 10 for Bernstein
basis or number of levels minus one for ordinal responses.}

\item{addconst_interaction}{Positive constant;
a constant added to the additive predictor of the interaction term.
If \code{NULL}, terms are left unchanged. If 0 and predictors have
negative values in their design matrix, the minimum value of all predictors
is added to ensure positivity. If > 0, the minimum value plus the
\code{addconst_interaction} is added to each predictor in the interaction
term. This ensures a monotone non-decreasing transformation function in
the response when using (tensor product) spline bases in the interacting
term.}

\item{latent_distr}{A \code{tfd_distribution} or character; the base distribution for
transformation models. If character, can be \code{"normal"}, \code{"logistic"},
\code{"gumbel"} or \code{"gompertz"}.}

\item{monitor_metrics}{See \code{\link[deepregression]{deepregression}}}

\item{trafo_options}{Options for transformation models such as the basis
function used, see \code{\link[deeptrafo]{trafo_control}} for more details.}

\item{...}{Additional arguments passed to \code{deepregression}}
}
\value{
See return statement of \code{\link[deeptrafo]{deeptrafo}}
}
\description{
Ordinal neural network transformation models
}
\examples{
df <- data.frame(y = ordered(sample.int(6, 50, TRUE)), x = rnorm(50))
if (reticulate::py_module_available("tensorflow") &
    reticulate::py_module_available("keras") &
    reticulate::py_module_available("tensorflow_probability")) {
    m <- ontram(response = ~ y, shift = ~ x, data = df)
   coef(m)
}

}
\references{
Kook, L. & Herzog, L., Hothorn, T., Dürr, O., & Sick, B. (2022).
    Deep and interpretable regression models for ordinal outcomes.
    Pattern Recognition, 122, 108263. DOI 10.1016/j.patcog.2021.108263
}
