/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.alg.BellmanFordIterator;
import org.jgrapht.alg.BellmanFordPathElement;

@Deprecated
public class BellmanFordShortestPath<V, E> {
    private static final double DEFAULT_EPSILON = 1.0E-9;
    protected Graph<V, E> graph;
    protected V startVertex;
    private BellmanFordIterator<V, E> iter;
    private int nMaxHops;
    private int passNumber;
    private double epsilon;

    public BellmanFordShortestPath(Graph<V, E> graph, V startVertex) {
        this(graph, startVertex, graph.vertexSet().size() - 1);
    }

    public BellmanFordShortestPath(Graph<V, E> graph, V startVertex, int nMaxHops) {
        this(graph, startVertex, nMaxHops, 1.0E-9);
    }

    public BellmanFordShortestPath(Graph<V, E> graph, V startVertex, int nMaxHops, double epsilon) {
        this.startVertex = startVertex;
        this.nMaxHops = nMaxHops;
        this.graph = graph;
        this.passNumber = 1;
        this.epsilon = epsilon;
    }

    public double getCost(V endVertex) {
        this.assertGetPath(endVertex);
        this.lazyCalculate();
        BellmanFordPathElement<V, E> pathElement = this.iter.getPathElement(endVertex);
        if (pathElement == null) {
            return Double.POSITIVE_INFINITY;
        }
        return pathElement.getCost();
    }

    public List<E> getPathEdgeList(V endVertex) {
        this.assertGetPath(endVertex);
        this.lazyCalculate();
        BellmanFordPathElement<V, E> pathElement = this.iter.getPathElement(endVertex);
        if (pathElement == null) {
            return null;
        }
        return pathElement.createEdgeListPath();
    }

    private void assertGetPath(V endVertex) {
        if (endVertex.equals(this.startVertex)) {
            throw new IllegalArgumentException("The end vertex is the same as the start vertex!");
        }
        if (!this.graph.containsVertex(endVertex)) {
            throw new IllegalArgumentException("Graph must contain the end vertex!");
        }
    }

    private void lazyCalculate() {
        if (this.iter == null) {
            this.iter = new BellmanFordIterator<V, E>(this.graph, this.startVertex, this.epsilon);
        }
        while (this.passNumber <= this.nMaxHops && this.iter.hasNext()) {
            this.iter.next();
            ++this.passNumber;
        }
    }

    public static <V, E> List<E> findPathBetween(Graph<V, E> graph, V startVertex, V endVertex) {
        BellmanFordShortestPath<V, E> alg = new BellmanFordShortestPath<V, E>(graph, startVertex);
        return alg.getPathEdgeList(endVertex);
    }
}

