% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dr_plot.R
\name{dr_plot}
\alias{dr_plot}
\title{Plot Delta R values from an object produced by dr_df()}
\usage{
dr_plot(deltar_list, name = "", method = "quantile", lim = c(0,0))
}
\arguments{
\item{deltar_list}{a list produced by the dr_df() function.}

\item{name}{an identification code of a data set. Default is blank.}

\item{method}{a character vector. If "quantile" is passed to this argument, medians of computed Delta R values will be plotted along with their quantiles. The latter are defined by the "CI" argument during the dr_df() function call. If "density" is passed to this argument, curves of Delta R densities will be plotted on the same plot.}

\item{lim}{a numeric vector, which contains values used to expand x-axis limits. Default is zero.}
}
\value{
None. Invoked for a side effect (plot).
}
\description{
This function makes a plot of Delta R values from a list produced by the dr_df() function. It can produce two kinds of plots: either medians of computed Delta R values can be plotted along with their quantiles, or curves of Delta R densities can be plotted on the same plot.
}
\details{
This function creates a plot of Delta R values computed for a data set by the dr_df() function. If "quantile" is passed to the "method" argument,  Delta R values computed for each sample or pair are being ordered by their medians and then their medians are plotted along with intervals containing true Delta R value with a previously set probability. If "density" is passed to the "method" argument, curves of Delta R densities will be plotted on the same plot.
}
\examples{
# Acquire "BSea" data set
data(BSea)
# Compute Delta R values and store them in the new object
bsea_res <- dr_df(BSea, method = "shell")
# Plot Delta R values with "quantile" method
dr_plot(bsea_res, name = "BSea")
# Expand x-axis of the plot
dr_plot(bsea_res, name = "BSea", lim = c(150, 250))
# Plot Delta R values with "density" method
dr_plot(bsea_res, name = "BSea", method = "density")
}
\seealso{
\code{\link{dr_shell}} \code{\link{dr_df}} \code{\link{dr_pair}}
}
