% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vci.R
\name{vci}
\alias{vci}
\title{Vertical Constraints Index (VCI)}
\usage{
vci(vdem, append = TRUE)
}
\arguments{
\item{vdem}{A \code{data.frame} of V-Dem data containing the required variables.}

\item{append}{Logical indicating whether to return the original data.frame
with \code{vci} and modified modified \code{v2xel_frefair} index (\code{v2xel_frefair_adj}).
If set to FALSE, the function returns a numeric vector of VCI scores.}
}
\value{
A data.frame with a modified \code{v2xel_frefair} index
(\code{v2xel_frefair_adj}) and the calculated VCI (\code{vci}).
}
\description{
Calculate an the vertical constraints index defined by Fjelde et al. (2021).
}
\details{
\subsection{Source}{

The vertical constraints metrics specified in this function were developed by
Fjelde et al. (2021) in:

Fjelde, H., Knutsen, C. H. & Nygård, H. M. 2021. Which Institutions Matter?
Re-Considering the Democratic Civil Peace. \emph{International Studies}
\emph{Quarterly} 65, 223–237, \doi{10.1093/isq/sqaa076}.
}

\subsection{The Index}{

The Vertical constraints index (VCI) represent civil liberties
attributed to the general populace the constrain executive actions. These
include suffrage, the presence of elections that appoint executive officials,
freedom of association, freedom of expression, and the presence of clean and
fair elections.
}

\subsection{Methods}{

At it's core, VCI is a multiplicative aggregation of 5 V-Dem variables
designed to measure suffrage, elected officials, freedom of association,
freedom of expression and clean elections, (\code{v2x_suffr}, \code{v2x_accex},
\code{v2x_frassoc_thick}, \code{v2x_freexp_thick}, \code{v2xel_frefair}). However, the final
component (\code{v2xel_frefair}) is a composite index developed with a Bayesian
factor analysis of 8 other V-Dem indicators (\code{v2elembaut}, \code{v2elembcap},
\code{v2elrgstry}, \code{v2elvotbuy}, \code{v2elirreg}, \code{v2elintim}, \code{v2elpeace},
\code{v2elfrfair}), of which, the authors adapted by purging 2 of the components
representing government intimidation or violent actions (\code{v2elintim},
\code{v2elpeace}) to prevent potential endogeneity in their regressions for the
onset of conflict; i.e. you don't want to predict the onset of conflict with
and independent variable that is, in-part, composed of measures of conflict.

Although the original \code{v2xel_frefair} composite index was developed using
V-Dem's \href{https://v-dem.net/static/website/files/wp/wp_21_5th.pdf}{Bayesian Factor Measurement Model},
the VCI adapted for this study took a simpler approach. In footnote 12,
the authors state that the modified composite index was created by averaging
the 6 non-violent indicators of \code{v2xel_frefair} (\code{v2elembaut}, \code{v2elembcap},
\code{v2elrgstry}, \code{v2elvotbuy}, \code{v2elirreg}, \code{v2elfrfair}). Although not
explicitly stated, it's presumed that the average for these 6 indicators was
converted to a 0-1 scale using "...the cumulative distribution function
of the normal distribution". This is the standard V-Dem procedure for their 0-1
interval indices as stated on page 7 of the \href{https://www.v-dem.net/static/website/img/refs/methodologyv111.pdf}{V-Dem V11.1 Methodology}
handbook.

Lastly, the VCI constructed for this manuscript was carried out using the
V-Dem 7.1 dataset. Since that time (current version is V11.1), 2 of the
indicators used in the VCI calculation have been renamed and slightly
altered:
\enumerate{
\item \code{v2x_freexp_thick} was converted to \code{v2x_freexp_altinf} starting with
version 11. The sub-components of this composite index were altered slightly,
but they still encompass the same concepts of censorship in media.
\item \code{v2x_accex} was renamed \code{v2x_elecoff} starting with version 8. This was
due to changes in the aggregation method for calculating the composite index.
Although the conceptual design for the composite indicator has not changed,
the aggregation formula is more complex and consists of 20 indicators
(opposed to 10 for the original \code{v2x_accex}).
}
}
}
\examples{
\donttest{
vdem <- demcon::get_vdem()

# Appended to the input dataset

vdem.dat<-demcon::vci(vdem, append = TRUE)

# Just return the numeric vector

vci<-demcon::vci(vdem = vdem, append = FALSE)}

}
\seealso{
\code{\link[=hci]{hci()}}, \link{vdem_vci_hci}
}
