% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all.equal.R
\name{all.equal.dendrogram}
\alias{all.equal.dendrogram}
\alias{all.equal.dendlist}
\title{Global Comparison of two (or more) dendrograms}
\usage{
\method{all.equal}{dendrogram}(target, current,
                                     use.edge.length = TRUE,
                                     use.tip.label.order = FALSE,
                                     use.tip.label = TRUE,
                                     use.topology = TRUE,
                                     tolerance = .Machine$double.eps^0.5,
                                     scale = NULL, ...)

\method{all.equal}{dendlist}(target, current, ...)
}
\arguments{
\item{target}{an object of type \link{dendrogram} or \link{dendlist}}

\item{current}{an object of type \link{dendrogram}}

\item{use.edge.length}{logical (TRUE). If to check branches' heights.}

\item{use.tip.label.order}{logical (FALSE). If to check labels are in the same and in identical order}

\item{use.tip.label}{logical (TRUE). If to check that labels are the same (regardless of order)}

\item{use.topology}{logical (TRUE). If to check teh existence of distinct edges}

\item{tolerance}{the numeric tolerance used to compare the branch lengths.}

\item{scale}{a positive number (NULL as default), comparison of branch height is made after scaling (i.e., dividing) them by this number.}

\item{...}{Ignored.}
}
\value{
Either TRUE (NULL for attr.all.equal) or a vector of mode "character" describing the differences
between target and current.
}
\description{
This function makes a global comparison of two or more dendrograms trees.

The function can get two \link{dendlist} objects and compare
them using \link{all.equal.list}. If a dendlist is in only "target"
(and not "current"), it will go through the dendlist and
compare all of the dendrograms within it to one another.
}
\examples{

\dontrun{

set.seed(23235)
ss <- sample(1:150, 10)
dend1 <- iris[ss, -5] \%>\%
  dist() \%>\%
  hclust("com") \%>\%
  as.dendrogram()
dend2 <- iris[ss, -5] \%>\%
  dist() \%>\%
  hclust("single") \%>\%
  as.dendrogram()
dend3 <- iris[ss, -5] \%>\%
  dist() \%>\%
  hclust("ave") \%>\%
  as.dendrogram()
dend4 <- iris[ss, -5] \%>\%
  dist() \%>\%
  hclust("centroid") \%>\%
  as.dendrogram()
#    cutree(dend1)

all.equal(dend1, dend1)
all.equal(dend1, dend2)
all.equal(dend1, dend2, use.edge.length = FALSE)
all.equal(dend1, dend2, use.edge.length = FALSE, use.topology = FALSE)

all.equal(dend2, dend4, use.edge.length = TRUE)
all.equal(dend2, dend4, use.edge.length = FALSE)

all.equal(dendlist(dend1, dend2, dend3, dend4))
all.equal(dendlist(dend1, dend2, dend3, dend4), use.edge.length = FALSE)
all.equal(dendlist(dend1, dend1, dend1))
}
}
\seealso{
\link{all.equal}, \link[ape]{all.equal.phylo}, \link{identical}
}
