% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_methods.R
\name{compare_methods}
\alias{compare_methods}
\title{compare_methods}
\usage{
compare_methods(formula, dataset, k = 3, repeats = 2, neurons = 1,
  MT_M = 4, MT_N = F, MT_U = F, MT_R = F, BMT_P = 100, BMT_I = 100,
  BMT_M = 4, BMT_N = F, BMT_U = F, BMT_R = F, RF_P = 100,
  RF_I = 100, RF_depth = 0, multiply = 5)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced
to that class): a symbolic description of the model to be fitted.}

\item{dataset}{a data frame with dependent and independent variables as
columns and (optional) years as row names.}

\item{k}{number of folds for cross-validation}

\item{repeats}{number of cross-validation repeats. Should be equal or more
than 2.}

\item{neurons}{positive integer that indicates the number of neurons used
for brnn method}

\item{MT_M}{minimum number of instances used by model trees}

\item{MT_N}{unpruned (argument for model trees)}

\item{MT_U}{unsmoothed (argument for model trees)}

\item{MT_R}{use regression trees (argument for model trees)}

\item{BMT_P}{bagSizePercent (argument for bagging of model trees)}

\item{BMT_I}{number of iterations (argument for bagging of model trees)}

\item{BMT_M}{minimum number of instances used by model trees}

\item{BMT_N}{unpruned (argument for bagging of model trees)}

\item{BMT_U}{unsmoothed (argument for bagging of model trees)}

\item{BMT_R}{use regression trees (argument for bagging of model trees)}

\item{RF_P}{bagSizePercent (argument for random forest)}

\item{RF_I}{number of iterations (argument for random forest)}

\item{RF_depth}{maxDepth (argument for random forest)}

\item{multiply}{an intiger that will be used to change the seed options
for different repeats. set.seed(multiply*5)}
}
\value{
a list with two elements. Element one is a data frame with
calculated measures for five regression methods. For each regression method
and each calculated measure, mean and standard deviation are given, together
with rank and share of rank 1.
Element two is a ggplot object of bias for validation data.
}
\description{
Calculates performance measures for train and test data of different
regression methods: multiple linear regression (MLR), artificial neural
networks with Bayesian regularization training algorithm (ANN), M5P model
trees (MT), model trees with bagging (BMT) and random forest of regression
trees (RF). Calculated performance measures are correlation coefficient,
root mean squared error (RMSE), root relative squared error (RSSE), index
of agreement (d), reduction of error (RE), coefficient of efficiency
(CE) and mean bias.
}
\examples{
\dontrun{
data(example_dataset_1)

# An example with default settings of machine learning algorithms
experiment_1 <- compare_methods(formula = MVA~.,
dataset = example_dataset_1, k = 3, repeats = 2)
experiment_1[[1]] # See a data frame results
experiment_1[[2]] # See a ggplot of mean bias for validation data

experiment_2 <- compare_methods(formula = MVA~.,
dataset = example_dataset_1, k = 3, repeats = 2, neurons = 1,
MT_M = 4, MT_N = FALSE, MT_U = FALSE, MT_R = FALSE, BMT_P = 100,
BMT_I = 100, BMT_M = 4, BMT_N = FALSE, BMT_U = FALSE, BMT_R = FALSE,
RF_P = 100, RF_I = 100, RF_depth= 0, multiply = 5)
experiment_2[[1]] # See a data frame results
experiment_2[[2]] # See a ggplot of mean bias for validation data

experiment_4 <- compare_methods(formula = MVA~.,
dataset = example_dataset_1, k = 2, repeats = 2)
}
}
\references{
Bishop, C.M., 1995. Neural Networks for Pattern Recognition. Oxford
University Press, Inc. 482 pp.

Breiman, L., 1996. Bagging predictors. Machine Learning 24, 123-140.

Breiman, L., 2001. Random forests. Machine Learning 45, 5-32.

Burden, F., Winkler, D., 2008. Bayesian Regularization of Neural Networks,
in: Livingstone, D.J. (ed.), Artificial Neural Networks: Methods and
Applications, vol. 458. Humana Press, Totowa, NJ, pp. 23-42.

Hastie, T., Tibshirani, R., Friedman, J.H., 2009. The Elements of
Statistical Learning : Data Mining, Inference, and Prediction, 2nd ed.
Springer, New York xxii, 745 p. pp.

Ho, T.K., 1995. Random decision forests, Proceedings of the Third
International Conference on Document Analysis and Recognition Volume 1.
IEEE Computer Society, pp. 278-282.

Hornik, K., Buchta, C., Zeileis, A., 2009. Open-source machine learning: R
meets Weka. Comput. Stat. 24, 225-232.

Perez-Rodriguez, P., Gianola, D., 2016. Brnn: Brnn (Bayesian Regularization
for Feed-forward Neural Networks). R package version 0.6.

Quinlan, J.R., 1992. Learning with Continuous Classes, Proceedings of the
5th Australian Joint Conference on Artificial Intelligence (AI '92). World
Scientific, Hobart, pp. 343-348.
}
