% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_extreme.R
\name{plot_extreme}
\alias{plot_extreme}
\title{plot_extreme}
\usage{
plot_extreme(result_daily_response, title = TRUE, ylimits = NULL)
}
\arguments{
\item{result_daily_response}{a list with three objects as produced by
daily_response function}

\item{title}{logical, if set to FALSE, no plot title is displayed}

\item{ylimits}{limit of the y axes. It should be given as ylimits = c(0,1)}
}
\value{
A ggplot2 object containing the plot display
}
\description{
Graphs a line plot of a row with the highest metric in a matrix, produced by
\code{\link{daily_response}} function.
}
\examples{
\dontrun{
data(LJ_daily_temperatures)
data(example_proxies_1)
Example1 <- daily_response(response = example_proxies_1,
env_data = LJ_daily_temperatures, method = "lm", metric = "r.squared",
fixed_width = 90, previous_year = TRUE, row_names_subset = TRUE)
plot_extreme(Example1)

Example2 <- daily_response(response = example_proxies_1,
env_data = LJ_daily_temperatures, method = "brnn",
metric = "adj.r.squared", lower_limit = 50, upper_limit = 55, neurons = 1,
row_names_subset = TRUE, previous_year = TRUE)
plot_extreme(Example2)

# Example with negative correlations
data(data_TRW_1)
LJ_daily_temperatures_subset = LJ_daily_temperatures[-c(53:55), ]
Example3 <- daily_response(response = data_TRW_1,
env_data = LJ_daily_temperatures_subset, method = "lm", metric = "adj.r.squared",
lower_limit = 35, upper_limit = 40, previous_year = TRUE, row_names_subset = TRUE)
plot_extreme(Example3)

Example4 <- daily_response(response = example_proxies_1,
env_data = LJ_daily_temperatures, method = "lm",
metric = "r.squared", lower_limit = 30, upper_limit = 120, neurons = 1,
row_names_subset = TRUE, previous_year = TRUE)
plot_extreme(Example4)
}

}
\keyword{internal}
