% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\docType{package}
\name{dendrometry-package}
\alias{dendrometry}
\alias{dendrometry-package}
\title{dendrometry: Forest Estimations and Dendrometric Computations}
\description{
Computation of dendrometric and structural parameters from forest inventory data. The objective is to provide an user-friendly R package for researchers, ecologists, foresters, statisticians, loggers and others persons who deal with forest inventory data. Useful conversion of angle value from degree to radian, conversion from angle to slope (in percentage) and their reciprocals as well as principal angle determination are also included. Position and dispersion parameters usually found in forest studies are implemented. The package contains Fibonacci series, its extensions and the Golden Number computation. Useful references are Arcadius Y. J. Akossou, Soufianou Arzouma, Eloi Y. Attakpa, Noël H. Fonton and Kouami Kokou (2013) <doi:10.3390/d5010099> and W. Bonou, R. Glele Kakaï, A.E. Assogbadjo, H.N. Fonton, B. Sinsin (2009) <doi:10.1016/j.foreco.2009.05.032> .
}
\details{
Type \code{RShowDoc("dendrometry", package = "dendrometry")} to read a HTML
user guide vignette.

Type \code{RShowDoc("dendrometry_pdf", package = "dendrometry")} to read a
PDF user guide vignette.

Type \code{demo(dendro, package = "dendrometry")} for a demo of dendrometric computations. Click on \code{Index} bellow to see the index of the package.

Type \code{demo(volume, package = "dendrometry")} for a demo of dendrometric computations. Click on \code{Index} bellow to see the index of the package.
}
\author{
\strong{Maintainer}: Narcisse Yehouenou \email{narcisstar211@gmail.com}

Other contributors:
\itemize{
  \item Information and Communication Technology for you ONG (ICT4U-ONG) \email{ict4uong@gmail.com} [funder]
}

}
\keyword{internal}
