% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrometry.R
\name{dbh}
\alias{dbh}
\alias{circum}
\title{Diameter (DBH) and Circumference}
\usage{
dbh(circum)

circum(dbh)
}
\arguments{
\item{circum}{numeric, vector of circumference.}

\item{dbh}{numeric, vector of diameter.}
}
\value{
\code{dbh}, returns diameter and \code{circum}, returns circumference.
}
\description{
\code{DBH} computes diameter (at breast height) based on
circumference (at breast height). \cr
\code{circum} computes circumference (at breast height) based on diameter
(at breast height). \cr
They are based on circle diameter and perimeter formulas.
}
\examples{
perimeter <- seq(30, 60, 1.4)
diameter <- dbh(perimeter)
circum(diameter)

}
\seealso{
See also \code{\link{height}} for tree  height.
}
