\name{cal_total_length}
\alias{cal_total_length}
\title{Calculate the total length of lines to draw the dendrogram.}
\usage{
cal_total_length(x)
}
\arguments{
  \item{x}{A dendrogram object.\code{x}}
}
\value{
output The total length.
}
\description{
\code{cal_total_length} is a code modified from
plot.dendrogram() to calculate the total length of lines to
draw a dendrogram. This function was developed to evaluate
the use of ink for visualization.
}
\examples{
#generate sample data
set.seed(1234); par(mar=c(0,0,0,0))
x <- rnorm(10, mean=rep(1:5, each=2), sd=0.4)
y <- rnorm(10, mean=rep(c(1,2), each=5), sd=0.4)
dataFrame <- data.frame(x=x, y=y, row.names=c(1:10))
#calculate Euclidian distance
distxy <- dist(dataFrame)
#hierachical clustering "complete" linkage by default
hc <- hclust(distxy)

total_length <- cal_total_length(as.dendrogram(hc))
}
\keyword{dendrogram}

