% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/denovolyzeMultiHits.R
\name{denovolyzeMultiHits}
\alias{denovolyzeMultiHits}
\title{Determine significance of genes with multiple \emph{de novos}}
\usage{
denovolyzeMultiHits(genes, classes, nsamples, nperms = 100,
  includeGenes = "all", includeClasses = c("syn", "mis", "lof", "prot",
  "all"), nVars = "actual", geneId = "geneName", probTable = NULL,
  misD = NULL, signifP = 3, roundExpected = 1)
}
\arguments{
\item{genes}{A vector of genes containing de novo variants.}

\item{classes}{A vector of classes of de novo variants.  Standard supported
classes are "syn" (synonymous), "mis" (missense), "non" (nonsense),
"splice" (splice), "frameshift" (frameshift) and "lof" (loss of function =
non + splice + frameshift). Additional classes that are supported by the
code, but are not included in the built-in probability tables, are
"stoploss","startloss", "misD" (damaging missense).  These labels may be
used for user-supplied probability tables. If "misD" is present, then "mis"
(in the input) implies non-damaging missense.}

\item{nsamples}{Number of individuals considered in de novo analysis.}

\item{nperms}{Number of permutations}

\item{includeGenes}{Genes to include in analysis. "all" or a vector of gene
names.}

\item{includeClasses}{Determines which variant classes are tabulated in
output.  In addition to the input classes, summaries can be produced for
"prot" (protein-altering = mis + lof), "all", and "protD" (protein damaging
= misD + lof, only available if misD included in user-specified probability
table).  If "misD" is present, then "mis" will return statistics for all
missense.  Non-damaging missense are not analysed separately.}

\item{nVars}{Select whether expected number of multihits is determined
  by "expected" total number of variants , or "actual" total.  Actual
  (default) is more conservative.}

\item{geneId}{Gene identifier used. One of "hgncID", "hgncSymbol",
"enstID", "ensgID" or "geneName" (default, equals ensembl "external_gene_name")}

\item{probTable}{Probability table. A user-defined table of probabilities can
be provided here, to replace the probability table included in the package.}

\item{misD}{If the user-specified probability table contains probabilities
  for a sub-category of missense variants (e.g. predicted to be damaging by
  an in silico algorithm), this column should be called misD, or the
  alternative name should be specified here.}

\item{signifP}{Number of significant figures used to round p-values in
output.}

\item{roundExpected}{Number of decimal places used to round expected burdens
in output.}
}
\value{
Returns a data.frame
}
\description{
Are there more genes containing >1 \emph{de novos} than expected?
}
\details{
See vignette (denovostats_intro) for more information.
}
\examples{
denovolyzeMultiHits(genes=autismDeNovos$gene,
                    classes=autismDeNovos$class,
                    nsamples=1078)
}
\keyword{keywords}

