% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.spectral}
\alias{predict.spectral}
\title{Obtain predicted density ratio values from a \code{spectral} object}
\usage{
\method{predict}{spectral}(
  object,
  newdata = NULL,
  sigma = c("sigmaopt", "all"),
  m = c("opt", "all"),
  ...
)
}
\arguments{
\item{object}{A \code{spectral} object}

\item{newdata}{Optional \code{matrix} new data set to compute the density}

\item{sigma}{A scalar with the Gaussian kernel width}

\item{m}{integer indicating the dimension of the eigenvector expansion}

\item{...}{Additional arguments to be passed to the function}
}
\value{
An array with predicted density ratio values from possibly new data,
but otherwise the numerator samples.
}
\description{
Obtain predicted density ratio values from a \code{spectral} object
}
\seealso{
\code{\link{predict}}, \code{\link{spectral}}
}
\keyword{predict}
\keyword{spectral}
